package tech.espublico.pades.server.signers.sign.timestamp;

import java.net.URL;

public class TimestamperException extends Exception {

	private static final long serialVersionUID = 1L;

	public enum TimestamperExceptionReason {
		INVALID_RESPONSE,
		BAD_REQUEST,
		COULD_NOT_CONNECT, 
		UNKNOWN_ERROR, 
		COULD_NOT_READ_RESPONSE,
		BACKUP_NO_CONFIGURE
	}
	
	private final TimestamperExceptionReason reason; 
	private final URL timestamperUrl;

	public TimestamperException(String message, URL timestamperUrl, TimestamperExceptionReason reason) {
		super(message);
		this.reason = reason;
		this.timestamperUrl = timestamperUrl;
	}

	public TimestamperException(String message, URL timestamperUrl, TimestamperExceptionReason reason, Throwable cause) {
		super(message, cause);
		this.reason = reason;
		this.timestamperUrl = timestamperUrl;
	}

	public TimestamperExceptionReason getReason() {
		return reason;
	}

	public URL getTimestamperUrl() {
		return timestamperUrl;
	}

}
