package tech.espublico.pades.server.signers.sign.ocsp;

public class OCSPValidationException extends Exception {

	private static final long serialVersionUID = 1L;
	
	public enum OCSPValidationExceptionReason {
		/**
		 * There has been a http connection, transport or response error
		 */
		HTTP_CLIENT_ERROR, 
		/**
		 * Cant create request object ¿?
		 */
		CANT_CREATE_REQUEST,
		/**
		 * Http client did not returned any error, but object is null
		 */
		INVALID_HTTP_RESPONSE,
		/**
		 * Http client returned a null response (this should be an error)
		 */
		INVALID_OCSP_RESPONSE, 
		/**
		 * OCSP Server does not know the certificate you are asking for
		 */
		UNKNOWN_CERTIFICATE,
		/**
		 * OCSP Server does know the certificate you are asking for, but it has been revoked at the time you are asking
		 */
		REVOKED_CERTIFICATE
	}
	
	private final OCSPValidationExceptionReason reason;

	public OCSPValidationException(OCSPValidationExceptionReason reason, String message) {
		super(message);
		this.reason = reason;
	}
	
	public OCSPValidationException(OCSPValidationExceptionReason reason, String message, Throwable cause) {
		super(message, cause);
		this.reason = reason;
	}

	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("OCSPValidationException reason: ").append(reason).append("\n");
		sb.append("message: ").append(getMessage());
		if (this.getCause() != null)
			sb.append("\ncause: ").append(getCause().toString());
		return sb.toString();
	}

	public OCSPValidationExceptionReason getReason() {
		return reason;
	}
	

}
