package tech.espublico.pades.server.signers.sign.ocsp;

import java.security.cert.X509Certificate;
import java.util.Date;

import org.bouncycastle.ocsp.OCSPResp;

import tech.espublico.pades.server.di.Service;
import tech.espublico.pades.server.di.ServiceLocator;
import tech.espublico.pades.server.models.CertificateOCSPConfiguration;

@Service
public interface OCSPService {

	static OCSPService instance() {
		return ServiceLocator.INSTANCE.getInstance(OCSPService.class);
	}

	OCSPResp validateOCSPResponse(X509Certificate x509Certificate, Date time, CertificateOCSPConfiguration signerOCSPConfiguration, X509Certificate issuerCertificate)
			throws OCSPValidationException, tech.espublico.pades.server.services.ocsp.OCSPValidationException;
}
