package tech.espublico.pades.server.signers.sign.helper;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

import javax.security.auth.x500.X500Principal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateHelper {
	private static final Logger log = LoggerFactory.getLogger(CertificateHelper.class);

	public static String getIssuerKeyWithOutSignatureAlgorithm(X509Certificate x509) {
		return getKey(x509, x509.getIssuerX500Principal(), false);
	}

	public static String getSubjectKeyWithOutSignatureAlgorithm(X509Certificate x509) {
		return getKey(x509, x509.getSubjectX500Principal(), false);
	}



	public static X509Certificate getIssuerCertificate(X509Certificate cert, Certificate[] chain) {
		String issuerKey = getIssuerKeyWithOutSignatureAlgorithm(cert);
		for (Certificate issuer : chain) {
			X509Certificate x509Issuer = (X509Certificate) issuer;
			String issuerDN = CertificateHelper.getSubjectKeyWithOutSignatureAlgorithm(x509Issuer);
			if (issuerDN.equals(issuerKey)) {
				return x509Issuer;
			}
		}

		return null;
	}

	private static String getKey(X509Certificate x509, Principal principal, boolean withSignatureAlgorithm) {
		String key;
		if (principal instanceof X500Principal) {
			X500Principal x500principal = (X500Principal) principal;
			key = x500principal.getName(X500Principal.CANONICAL);
		} else {
			key = principal.getName().toLowerCase().replaceAll(" ", "");
		}

		if (withSignatureAlgorithm) {
			String algorithmName = transformAlgName(x509.getSigAlgName());
			return key + "-" + algorithmName;
		} else
			return key;
	}

	private static String transformAlgName(String algname) {

		switch (algname) {
			case "SHA512WithRSAEncryption":
			case "SHA512withRSAEncryption":
				return "SHA512withRSA";
			case "SHA256WithRSAEncryption":
			case "SHA256withRSAEncryption":
				return "SHA256withRSA";
			case "SHA1WithRSAEncryption":
			case "SHA1withRSAEncryption":
				return "SHA1withRSA";

			default:
				return algname;
		}
	}
}
