package tech.espublico.pades.server.signers.sign.exceptions;

public class InvalidSignatureException extends Exception {

	private static final long serialVersionUID = 1L;

	public enum InvalidSignatureExceptionReason {
		/**
		 * PKCS7 is not parseable
		 */
		COULD_NOT_PARSE_PKCS7, 
		/**
		 * The certificate chain generated from parsing pkcs7 data is empty
		 */
		EMPTY_CERTIFICATE_CHAIN, 
		/**
		 * Signer certificate is expired
		 */
		CERTIFICATE_EXPIRED, 
		/**
		 * Signer certificate is not valid yet
		 */
		CERTIFICATE_NOT_VALID_YET,
		/**
		 * Some strange and unknown error has happened (no such algorithm, or provider, generally it is a configuration issue)
		 */
		UNKNOWN, 
		/**
		 * Signer is not the same as the provided certificate
		 */
		SIGNER_NOT_FOUND,
		/**
		 * Signature is invalid (generated hash from content plus certificate differs from the one provided in the signature information)
		 */
		INVALID_SIGNATURE,
		/**
		 * The private key used to sign is not valid for that purpose, or the public key is no valid to decrypt the signature bytes
		 */
		INVALID_KEY,
		/**
		 * Signed attributes does not contains signin time OID: 1.2.840.113549.1.9.5
		 */
		NO_SIGNIN_TIME,
		/**
		 * Unable to obtain signer certificate
		 */
		INVALID_CERTIFICATE,
		/**
		 * Signed attributes are incomplete, or contains more than one signin time
		 */
		INVALID_SIGNED_ATTRIBUTES
	}
	
	private final InvalidSignatureExceptionReason reason;

	public InvalidSignatureException(InvalidSignatureExceptionReason reason) {
		super(String.format("Invalid signature", reason.toString()));
		this.reason = reason;
	}

	public InvalidSignatureException(InvalidSignatureExceptionReason reason, Throwable cause) {
		super(String.format("Invalid signature with cause", reason.toString()), cause);
		this.reason = reason;
	}

	public InvalidSignatureExceptionReason getReason() {
		return reason;
	}
	
	@Override
	public String toString() {
		return String.format("%s: %s", getMessage(), reason.toString());
	}

}
