package tech.espublico.pades.server.signers.sign;

import java.io.Serializable;

import org.bouncycastle.asn1.ASN1EncodableVector;

/**
 * Second hash result class, contains the bytes and the attributes to sign<br/>
 * <br/>
 * This class is created by the PDFSigner.getSecondHashToSign method
 */
public class SecondHashResult implements Serializable {

	private static final long serialVersionUID = 1L;

	private byte[] bytesToSign;

	private ASN1EncodableVector signedAttributes;

	public SecondHashResult(byte[] hash, ASN1EncodableVector signedAttributes) {
		this.bytesToSign = hash;
		this.signedAttributes = signedAttributes;
	}

	public byte[] getHash() {
		return bytesToSign;
	}

	public ASN1EncodableVector getSignedAttributes() {
		return signedAttributes;
	}
}