package tech.espublico.pades.server.signers.sign;

import javax.xml.crypto.dsig.DigestMethod;


/**
 * Supported Algorithms
 */
public enum DigestAlgorithm {

	SHA1("SHA-1", "1.3.14.3.2.26", DigestMethod.SHA1),
	SHA256("SHA-256", "2.16.840.1.101.3.4.2.1", DigestMethod.SHA256),
	SHA512("SHA-512", "2.16.840.1.101.3.4.2.3", DigestMethod.SHA512);

	private String name;
	private String oid;
	private String xmlId;

	private DigestAlgorithm(String name, String oid, String xmlId) {
		this.name = name;
		this.oid = oid;
		this.xmlId = xmlId;
	}

	public String getName() {
		return name;
	}

	public String getOid() {
		return oid;
	}

	public String getXmlId() {
		return xmlId;
	}
}
