package tech.espublico.pades.server.signers.service.sign;

import java.nio.file.Path;
import java.security.cert.Certificate;

import com.itextpdf.text.pdf.PdfStamper;

import tech.espublico.pades.server.models.PDFSignerModel.ByteMode;
import tech.espublico.pades.server.models.TimestamperData;
import tech.espublico.pades.server.signers.service.digest.hash.PDFHash;

public class PDFSignModel {

	private byte[] hash;
	private ByteMode byteMode;
	private Path preparedPdf;
	private tech.espublico.pades.server.signers.service.digest.hash.PDFHash PDFHash;
	private Certificate[] certs;
	private TimestamperData timestamperData;
	private TimestamperData backupTimestamperData;

	public PDFSignModel(byte[] hash, ByteMode byteMode, PdfStamper pdfStamper, Path preparedPdf, PDFHash PDFHash, Certificate[] certs,
			TimestamperData timestamperData, TimestamperData backupTimestamperData) {
		this.hash = hash;
		this.byteMode = byteMode;
		this.preparedPdf = preparedPdf;
		this.PDFHash = PDFHash;
		this.certs = certs;
		this.timestamperData = timestamperData;
		this.backupTimestamperData = backupTimestamperData;
	}

	public byte[] getHash() {
		return hash;
	}

	public void setHash(byte[] hash) {
		this.hash = hash;
	}

	public ByteMode getByteMode() {
		return byteMode;
	}

	public void setByteMode(ByteMode byteMode) {
		this.byteMode = byteMode;
	}

	public Path getPreparedPdf() {
		return preparedPdf;
	}

	public void setPreparedPdf(Path preparedPdf) {
		this.preparedPdf = preparedPdf;
	}

	public PDFHash getPDFHash() {
		return PDFHash;
	}

	public void setPDFHash(PDFHash pdfHash) {
		this.PDFHash = pdfHash;
	}

	public Certificate[] getCerts() {
		return certs;
	}

	public void setCerts(Certificate[] certs) {
		this.certs = certs;
	}

	public TimestamperData getTimestamperData() {
		return timestamperData;
	}

	public void setTimestamperData(TimestamperData timestamperData) {
		this.timestamperData = timestamperData;
	}

	public TimestamperData getBackupTimestamperData() {
		return backupTimestamperData;
	}

	public void setBackupTimestamperData(TimestamperData backupTimestamperData) {
		this.backupTimestamperData = backupTimestamperData;
	}

	public static class Builder {
		private byte[] hash;
		private ByteMode byteMode;
		private PdfStamper pdfStamper;
		private Path preparedPdf;
		private PDFHash pdfHash;
		private Certificate[] certs;
		private TimestamperData timestamperData;
		private TimestamperData backupTimestamperData;

		public Builder setHash(byte[] hash) {
			this.hash = hash;
			return this;
		}

		public Builder setByteMode(ByteMode byteMode) {
			this.byteMode = byteMode;
			return this;
		}

		public Builder setPdfStamper(PdfStamper pdfStamper) {
			this.pdfStamper = pdfStamper;
			return this;
		}

		public Builder setPreparedPdf(Path preparedPdf) {
			this.preparedPdf = preparedPdf;
			return this;
		}

		public Builder setPDFHash(PDFHash pdfHash) {
			this.pdfHash = pdfHash;
			return this;
		}

		public Builder setCerts(Certificate[] certs) {
			this.certs = certs;
			return this;
		}

		public Builder setTimestamperData(TimestamperData timestamperData) {
			this.timestamperData = timestamperData;
			return this;
		}

		public Builder setBackupTimestamperData(TimestamperData backupTimestamperData) {
			this.backupTimestamperData = backupTimestamperData;
			return this;
		}

		public PDFSignModel createPDFSignModel() {
			return new PDFSignModel(hash, byteMode, pdfStamper, preparedPdf, pdfHash, certs, timestamperData, backupTimestamperData);
		}
	}
}
