package tech.espublico.pades.server.signers.service.prepare;

import java.awt.Point;
import java.io.IOException;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;

import tech.espublico.pades.server.helper.CollectionsHelper;
import tech.espublico.pades.server.helper.StringUtils;
import tech.espublico.pades.server.models.PDFSignatureSignerData;
import tech.espublico.pades.server.signers.service.PDFPrepareHelper;
import tech.espublico.pades.server.signers.service.PDFSignatureModel;
import tech.espublico.pades.server.signers.sign.SignatureNames;
import tech.espublico.pades.server.services.style.FontService;

public class PDFPrepareSignatureFields {

	public static void addSignatureFields(//
			PDFSignatureModel pdfSignatureModel,//
			PdfStamper signatureStamper, //
			PdfWriter writer, //
			float height, float width, //
			boolean isHorizontal, //
			int pageRotation)//
			throws DocumentException, IOException {

		float marginX = 20;
		float marginTop = isHorizontal ? 20 : 110;
		float marginBottom = 30;
		float marginBetweenSignaturesY = 5;


		int SIGNATURES_PER_PAGE = isHorizontal ? //
				PDFPrepareHelper.SIGNATURES_PER_PAGE_HORIZONTAL : PDFPrepareHelper.SIGNATURES_PER_PAGE_VERTICAL;

		float fieldHeight = (height - marginTop - marginBottom - ((SIGNATURES_PER_PAGE - 1) * marginBetweenSignaturesY)) / SIGNATURES_PER_PAGE;
		float fieldWidht = PDFPrepareHelper.SIGNATURE_FIELD_WIDTH;

		int rotation = 90 + pageRotation;

		boolean visibleSignature = pdfSignatureModel.isVisibleSignature();

		for (int signature = 1; signature <= pdfSignatureModel.getTotalSignatures(); signature++) {
			float llx, lly, urx, ury;
			PdfFormField sig = PdfFormField.createSignature(writer);

			int page = ((signature - 1) / SIGNATURES_PER_PAGE) + 1;
			int position = (signature - 1) % SIGNATURES_PER_PAGE;

			Rectangle signaturePosition;
			llx = marginX; // Lower left X
			lly = height - (marginTop + fieldHeight + (position * (fieldHeight + marginBetweenSignaturesY))); // Lower left y
			urx = llx + fieldWidht; // Upper right X
			ury = lly + fieldHeight; // Upper right y
			signaturePosition = new Rectangle(llx, lly, urx, ury);

			int correction = (int) (fieldHeight - fieldWidht);
			if (pageRotation > 0)
				signaturePosition.setLeft(llx - correction);

			if (visibleSignature) {
				PdfContentByte cb = signatureStamper.getOverContent(page);
				cb.setLineWidth(0.5f);
				cb.setColorStroke(BaseColor.GRAY);
				cb.rectangle(llx, lly, fieldWidht, fieldHeight);
				cb.stroke();
			}

			sig.setPage(page);
			sig.setWidget(signaturePosition, PdfName.HIGHLIGHT);
			sig.setFlags(PdfAnnotation.FLAGS_PRINT);
			sig.setFieldName(SignatureNames.getSignatureFieldName(signature, pdfSignatureModel.getTotalSignatures()));

			signatureStamper.addAnnotation(sig, page);

			if (CollectionsHelper.isNotEmpty(pdfSignatureModel.getSigners()) && visibleSignature) {

				PdfFormField htmlField = new PdfFormField(writer, //
						signaturePosition.getLeft(), //
						signaturePosition.getBottom(), //
						signaturePosition.getRight(), //
						signaturePosition.getTop(), null);
				htmlField.setButton(PdfFormField.FF_MULTILINE);
				htmlField.setFlags(PdfAnnotation.FLAGS_PRINT);
				htmlField.setFieldName("user" + signature);
				htmlField.setPage(page);

				// Create the text appearance
				int rectHtmlWidth = (int) (signaturePosition.getRight() - signaturePosition.getLeft());
				int rectHtmlHeight = (int) (signaturePosition.getTop() - signaturePosition.getBottom());
				PdfAppearance pa = PdfAppearance.createAppearance(writer, rectHtmlWidth, rectHtmlHeight);

				PDFSignatureSignerData signer = pdfSignatureModel.getSigners().get(signature - 1);
				String signerNameAndCount = StringUtils.voidIfNull(signer.getName());
				if (pdfSignatureModel.getSignatureCountLabel() != null)
					signerNameAndCount += " " + String.format(pdfSignatureModel.getSignatureCountLabel(), //
							signature, pdfSignatureModel.getTotalSignatures());
				String signerCharge = StringUtils.voidIfNull(signer.getCharge());

				int fontSize = PDFPrepareHelper.SIGNATURE_FIELD_FONT_SIZE;
				int SIGNATURE_FIELD_IMAGE_MAX_HEIGHT = (int) (fieldHeight * PDFPrepareHelper.SIGNATURE_FIELD_IMAGE_MAX_HEIGHT_PERCENT);
				int margin = (int) ((PDFPrepareHelper.SIGNATURE_FIELD_MARGIN * 2) + SIGNATURE_FIELD_IMAGE_MAX_HEIGHT);

				int size = fontSize + 2;
				if (pageRotation > 0)
					size += correction;

				pa.beginText();
				BaseFont font = BaseFont.createFont(FontService.instance().getFont3(), BaseFont.CP1252, BaseFont.EMBEDDED);
				pa.setFontAndSize(font, fontSize);
				Point pos = PDFPrepareHelper//
						.getPosition(rectHtmlWidth, rectHtmlHeight, pageRotation, size, margin);
				pa.showTextAlignedKerned(PdfContentByte.ALIGN_LEFT, signerNameAndCount, pos.x, pos.y, rotation);
				pa.newlineText();

				font = BaseFont.createFont(FontService.instance().getFont4(), BaseFont.CP1252, BaseFont.EMBEDDED);
				pa.setFontAndSize(font, fontSize);
				size += fontSize;
				pos = PDFPrepareHelper//
						.getPosition(rectHtmlWidth, rectHtmlHeight, pageRotation, size, margin);
				pa.showTextAlignedKerned(PdfContentByte.ALIGN_LEFT, signerCharge, pos.x, pos.y, rotation);
				pa.endText();

				htmlField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pa);

				signatureStamper.addAnnotation(htmlField, page);
			}
		}
	}
}
