package tech.espublico.pades.server.signers.service.prepare;

import java.awt.Point;
import java.io.IOException;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;

import tech.espublico.pades.server.helper.StringUtils;
import tech.espublico.pades.server.signers.service.PDFPrepareHelper;
import tech.espublico.pades.server.signers.service.PDFSignatureModel;

public class PDFPrepareMark {
		public static void addMarkLabels(//
				PDFSignatureModel pdfSignatureModel,//
				PdfStamper signatureStamper, //
				PdfWriter writer, //
				PdfReader reader, //
				float pageHeight, float pageWidth,//
				BaseFont font) //
				throws IOException, DocumentException {

		if (pdfSignatureModel.getMark() == null)
			return;

		String label1 = StringUtils.voidIfNull(pdfSignatureModel.getSubMarkLeft());
		String label2 = StringUtils.voidIfNull(pdfSignatureModel.getSubMarkRight());
		String labelTitle = StringUtils.voidIfNull(pdfSignatureModel.getMark());
		addLabelsInAllPages(signatureStamper, writer, reader, pageHeight, pageWidth, font, label1, label2, labelTitle);
	}
	private static void addLabelsInAllPages(//
			PdfStamper signatureStamper,//
			PdfWriter writer, //
			PdfReader reader, //
			float pageHeight, float pageWidth,//
			BaseFont font, //
			String label1,//
			String label2, //
			String labelTitle) //
			throws IOException, DocumentException {

		int fontSize = 9;
		PdfFormField htmlField;
		PdfFormField htmlField2;
		label1 += "   " + label2;

		int pageRotation = reader.getPageRotation(1) % 360;
		int rotation = 90 + pageRotation;

		Rectangle rectHtmlField = PDFPrepareHelper.getRectangle(//
						(int) (pageWidth - PDFPrepareHelper.LABEL_WIDTH), //
						PDFPrepareHelper.BARCODE_HEIGHT, //
						pageWidth, //
						pageHeight, //
						pageRotation);//
		int rectHtmlWidth = (int) (rectHtmlField.getRight() - rectHtmlField.getLeft());
		int rectHtmlHeight = (int) (rectHtmlField.getTop() - rectHtmlField.getBottom());

		for (int index = 1; index <= reader.getNumberOfPages(); index++) {

			// Label Title
			{
				PdfAppearance pa = PdfAppearance.createAppearance(writer, rectHtmlWidth, rectHtmlHeight);
				pa.beginText();
				pa.setFontAndSize(font, fontSize * 2);
				Point position = PDFPrepareHelper//
						.getPosition(rectHtmlWidth, rectHtmlHeight, pageRotation, fontSize * 2);
				pa.showTextAlignedKerned(PdfContentByte.ALIGN_LEFT, labelTitle, position.x, position.y, rotation);
				pa.endText();

				htmlField = new PdfFormField(writer, //
						rectHtmlField.getLeft(), //
						rectHtmlField.getBottom(), //
						rectHtmlField.getRight(), //
						rectHtmlField.getTop(), null);
				htmlField.setButton(PdfFormField.FF_MULTILINE);
				htmlField.setFlags(PdfAnnotation.FLAGS_PRINT);
				htmlField.setFieldName("fieldName1" + index);
				htmlField.setPage(index);
				htmlField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pa);

				signatureStamper.addAnnotation(htmlField, index);
			}

			// Label 1
			{
				PdfAppearance pa = PdfAppearance.createAppearance(writer, rectHtmlWidth, rectHtmlHeight);
				pa.beginText();
				pa.setFontAndSize(font, fontSize);
				Point position = PDFPrepareHelper//
						.getPosition(rectHtmlWidth, rectHtmlHeight, pageRotation, fontSize * 3 + 2, 1);
				pa.showTextAlignedKerned(PdfContentByte.ALIGN_LEFT, label1, position.x, position.y, rotation);
				pa.endText();

				htmlField2 = new PdfFormField(writer, //
						rectHtmlField.getLeft(), //
						rectHtmlField.getBottom(), //
						rectHtmlField.getRight(), //
						rectHtmlField.getTop(), null);
				htmlField2.setButton(PdfFormField.FF_MULTILINE);
				htmlField2.setFlags(PdfAnnotation.FLAGS_PRINT);
				htmlField2.setFieldName("fieldName2" + index);
				htmlField2.setPage(index);
				htmlField2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pa);

				signatureStamper.addAnnotation(htmlField2, index);
			}
		}
	}
}
