package tech.espublico.pades.server.signers.service.digest.second;

import java.security.cert.Certificate;
import java.util.Calendar;

import tech.espublico.pades.server.models.CertificateOCSPConfiguration;
import tech.espublico.pades.server.models.PDFSignerModel.ByteMode;

public class PDFSecondHashModel {
	private ByteMode byteMode;
	private Calendar signingDate;
	private Certificate[] certs;
	private CertificateOCSPConfiguration signerOCSPConfiguration;

	public PDFSecondHashModel(ByteMode byteMode, Calendar signingDate, Certificate[] certs, CertificateOCSPConfiguration signerOCSPConfiguration) {
		this.byteMode = byteMode;
		this.signingDate = signingDate;
		this.certs = certs;
		this.signerOCSPConfiguration = signerOCSPConfiguration;
	}

	public ByteMode getByteMode() {
		return byteMode;
	}

	public void setByteMode(ByteMode byteMode) {
		this.byteMode = byteMode;
	}

	public Calendar getSigningDate() {
		return signingDate;
	}

	public void setSigningDate(Calendar signingDate) {
		this.signingDate = signingDate;
	}

	public Certificate[] getCerts() {
		return certs;
	}

	public void setCerts(Certificate[]  certs) {
		this.certs = certs;
	}

	public CertificateOCSPConfiguration getSignerOCSPConfiguration() {
		return signerOCSPConfiguration;
	}

	public void setSignerOCSPConfiguration(CertificateOCSPConfiguration signerOCSPConfiguration) {
		this.signerOCSPConfiguration = signerOCSPConfiguration;
	}

	public static class Builder {
		private ByteMode byteMode;
		private Calendar signingDate;
		private Certificate[] certs;
		private CertificateOCSPConfiguration signerOCSPConfiguration;

		public Builder setByteMode(ByteMode byteMode) {
			this.byteMode = byteMode;
			return this;
		}

		public Builder setSigningDate(Calendar signingDate) {
			this.signingDate = signingDate;
			return this;
		}

		public Builder setCerts(Certificate[] certs) {
			this.certs = certs;
			return this;
		}

		public Builder setSignerOCSPConfiguration(CertificateOCSPConfiguration signerOCSPConfiguration) {
			this.signerOCSPConfiguration = signerOCSPConfiguration;
			return this;
		}

		public PDFSecondHashModel createPDFSecondHashModel() {
			return new PDFSecondHashModel(byteMode, signingDate, certs, signerOCSPConfiguration);
		}
	}
}
