package tech.espublico.pades.server.signers.service.digest.hash;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;

import tech.espublico.pades.server.helper.IOHelper;

public class PDFHash implements AutoCloseable {

	private static final Logger log = LoggerFactory.getLogger(PDFHash.class);

	PdfReader pdfReader;

	BufferedOutputStream bufferedOutputStream;
	OutputStream outputStream;
	PdfStamper pdfStamper;

	PdfSignatureAppearance pdfSignatureAppearance;
	Path signedPdf;

	byte[] contentHash;

	public PdfReader getPdfReader() {
		return pdfReader;
	}

	public void setPdfReader(PdfReader pdfReader) {
		this.pdfReader = pdfReader;
	}

	public BufferedOutputStream getBufferedOutputStream() {
		return bufferedOutputStream;
	}

	public void setBufferedOutputStream(BufferedOutputStream bufferedOutputStream) {
		this.bufferedOutputStream = bufferedOutputStream;
	}

	public OutputStream getOutputStream() {
		return outputStream;
	}

	public void setOutputStream(OutputStream outputStream) {
		this.outputStream = outputStream;
	}

	public PdfStamper getPdfStamper() {
		return pdfStamper;
	}

	public void setPdfStamper(PdfStamper pdfStamper) {
		this.pdfStamper = pdfStamper;
	}

	public PdfSignatureAppearance getPdfSignatureAppearance() {
		return pdfSignatureAppearance;
	}

	public void setPdfSignatureAppearance(PdfSignatureAppearance pdfSignatureAppearance) {
		this.pdfSignatureAppearance = pdfSignatureAppearance;
	}

	public Path getSignedPdf() {
		return signedPdf;
	}

	public void setSignedPdf(Path signedPdf) {
		this.signedPdf = signedPdf;
	}

	public byte[] getContentHash() {
		return contentHash;
	}

	public void setContentHash(byte[] contentHash) {
		this.contentHash = contentHash;
	}

	@Override
	public void close() throws IOException {
		IOHelper.closeQuietly(this.bufferedOutputStream);
		IOHelper.closeQuietly(this.outputStream);
	}
}
