package tech.espublico.pades.server.signers.service.digest.hash;

import java.nio.file.Path;
import java.security.cert.Certificate;
import java.util.Calendar;

public class PDFDigestModel {
	private Certificate[] certs;
	private String reason;
	private String location;
	private Calendar signDate;
	private int signatureNumber;
	private String contactInfo;
	private boolean certifyNoChangesAllowed;
	private String userName;
	private boolean visibleSignature;
	private String signatureCountLabel;
	private int totalSignatures;
	private String userCharge;
	private String signatureDate;
	private Path signatureImage;

	public PDFDigestModel(Certificate[] certs, String reason, String location, Calendar signDate, int signatureNumber, String contactInfo,
			boolean certifyNoChangesAllowed, String userName, boolean visibleSignature, String signatureCountLabel, int totalSignatures, String userCharge,
			String signatureDate, Path signatureImage) {
		this.certs = certs;
		this.reason = reason;
		this.location = location;
		this.signDate = signDate;
		this.signatureNumber = signatureNumber;
		this.contactInfo = contactInfo;
		this.certifyNoChangesAllowed = certifyNoChangesAllowed;
		this.userName = userName;
		this.visibleSignature = visibleSignature;
		this.signatureCountLabel = signatureCountLabel;
		this.totalSignatures = totalSignatures;
		this.userCharge = userCharge;
		this.signatureDate = signatureDate;
		this.signatureImage = signatureImage;
	}

	public Certificate[] getCerts() {
		return certs;
	}

	public void setCerts(Certificate[] certs) {
		this.certs = certs;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public Calendar getSignDate() {
		return signDate;
	}

	public void setSignDate(Calendar signDate) {
		this.signDate = signDate;
	}

	public int getSignatureNumber() {
		return signatureNumber;
	}

	public void setSignatureNumber(int signatureNumber) {
		this.signatureNumber = signatureNumber;
	}

	public String getContactInfo() {
		return contactInfo;
	}

	public void setContactInfo(String contactInfo) {
		this.contactInfo = contactInfo;
	}

	public boolean isCertifyNoChangesAllowed() {
		return certifyNoChangesAllowed;
	}

	public void setCertifyNoChangesAllowed(boolean certifyNoChangesAllowed) {
		this.certifyNoChangesAllowed = certifyNoChangesAllowed;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public boolean isVisibleSignature() {
		return visibleSignature;
	}

	public void setVisibleSignature(boolean visibleSignature) {
		this.visibleSignature = visibleSignature;
	}

	public String getSignatureCountLabel() {
		return signatureCountLabel;
	}

	public void setSignatureCountLabel(String signatureCountLabel) {
		this.signatureCountLabel = signatureCountLabel;
	}

	public int getTotalSignatures() {
		return totalSignatures;
	}

	public void setTotalSignatures(int totalSignatures) {
		this.totalSignatures = totalSignatures;
	}

	public String getUserCharge() {
		return userCharge;
	}

	public void setUserCharge(String userCharge) {
		this.userCharge = userCharge;
	}

	public String getSignatureDate() {
		return signatureDate;
	}

	public void setSignatureDate(String signatureDate) {
		this.signatureDate = signatureDate;
	}

	public Path getSignatureImage() {
		return signatureImage;
	}

	public void setSignatureImage(Path signatureImage) {
		this.signatureImage = signatureImage;
	}

	public static class Builder {
		private Certificate[] certs;
		private String reason;
		private String location;
		private Calendar signDate;
		private int signatureNumber;
		private String contactInfo;
		private boolean certifyNoChangesAllowed;
		private String userName;
		private boolean visibleSignature;
		private String signatureCountLabel;
		private int totalSignatures;
		private String userCharge;
		private String signatureDate;
		private Path signatureImage;

		public Builder setCerts(Certificate[] certs) {
			this.certs = certs;
			return this;
		}

		public Builder setReason(String reason) {
			this.reason = reason;
			return this;
		}

		public Builder setLocation(String location) {
			this.location = location;
			return this;
		}

		public Builder setSignDate(Calendar signDate) {
			this.signDate = signDate;
			return this;
		}

		public Builder setSignatureNumber(int signatureNumber) {
			this.signatureNumber = signatureNumber;
			return this;
		}

		public Builder setContactInfo(String contactInfo) {
			this.contactInfo = contactInfo;
			return this;
		}

		public Builder setCertifyNoChangesAllowed(boolean certifyNoChangesAllowed) {
			this.certifyNoChangesAllowed = certifyNoChangesAllowed;
			return this;
		}

		public Builder setUserName(String userName) {
			this.userName = userName;
			return this;
		}

		public Builder setVisibleSignature(boolean visibleSignature) {
			this.visibleSignature = visibleSignature;
			return this;
		}

		public Builder setSignatureCountLabel(String signatureCountLabel) {
			this.signatureCountLabel = signatureCountLabel;
			return this;
		}

		public Builder setTotalSignatures(int totalSignatures) {
			this.totalSignatures = totalSignatures;
			return this;
		}

		public Builder setUserCharge(String userCharge) {
			this.userCharge = userCharge;
			return this;
		}

		public Builder setSignatureDate(String signatureDate) {
			this.signatureDate = signatureDate;
			return this;
		}

		public Builder setSignatureImage(Path signatureImage) {
			this.signatureImage = signatureImage;
			return this;
		}

		public PDFDigestModel createPDFDigestModel() {
			return new PDFDigestModel(certs, reason, location, signDate, signatureNumber, contactInfo, certifyNoChangesAllowed, userName, visibleSignature,
					signatureCountLabel, totalSignatures, userCharge, signatureDate, signatureImage);
		}
	}
}
