package tech.espublico.pades.server.signers.service.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import tech.espublico.pades.server.signers.sign.DigestAlgorithm;
import tech.espublico.pades.server.exceptions.OpenSignatureException;
import tech.espublico.pades.server.exceptions.OpenSignatureException.OpenSignatureExceptionReason;

public class DigestUtils {

	private static MessageDigest newDigester(DigestAlgorithm alg) throws OpenSignatureException {
		try {
			return MessageDigest.getInstance(alg.getName());
		} catch (NoSuchAlgorithmException e) {
			throw new OpenSignatureException("Could not get " + alg.getName() + " algorithm instance", e,
					OpenSignatureExceptionReason.SIGN_CANT_CREATE_SIGNATURE);
		}
	}

	public static byte[] digest(DigestAlgorithm alg, byte[] bytes) throws OpenSignatureException {
		return newDigester(alg).digest(bytes);
	}
}
