package tech.espublico.pades.server.signers.service;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

import tech.espublico.pades.server.models.PDFSignatureSignerData;

public class PDFSignatureModel {

	public enum BarcodeType {
		BARCODE,
		QR,
	}

	private final Path unsignedPath;

	private final Path barcodeImage;
	private final BarcodeType barcodeType;

	private final String downloadText;
	private final String pageCountLabel;

	private final String mark;
	private final String subMarkLeft;
	private final String subMarkRight;

	private final List<PDFSignatureSignerData> signers;
	private final String signatureCountLabel;
	private final boolean visibleSignature;

	private final int totalSignatures;

	public PDFSignatureModel(Path unsignedPath, Path barcodeImage, BarcodeType barcodeType, String downloadText, String pageCountLabel, String mark,
			String subMarkLeft, String subMarkRight, List<PDFSignatureSignerData> signers, String signatureCountLabel, boolean visibleSignature, int totalSignatures) {
		this.unsignedPath = unsignedPath;
		this.barcodeImage = barcodeImage;
		this.barcodeType = barcodeType;
		this.downloadText = downloadText;
		this.pageCountLabel = pageCountLabel;
		this.mark = mark;
		this.subMarkLeft = subMarkLeft;
		this.subMarkRight = subMarkRight;
		this.signers = signers;
		this.signatureCountLabel = signatureCountLabel;
		this.visibleSignature = visibleSignature;
		this.totalSignatures = totalSignatures;
	}

	public List<PDFSignatureSignerData> getSigners() {
		return signers;
	}

	public int getTotalSignatures() {
		return totalSignatures;
	}

	public Path getUnsignedPath() {
		return unsignedPath;
	}

	public Path getBarcodeImage() {
		return barcodeImage;
	}

	public BarcodeType getBarcodeType() {
		return barcodeType;
	}

	public String getDownloadText() {
		return downloadText;
	}

	public String getPageCountLabel() {
		return pageCountLabel;
	}

	public String getMark() {
		return mark;
	}

	public String getSubMarkLeft() {
		return subMarkLeft;
	}

	public String getSubMarkRight() {
		return subMarkRight;
	}

	public String getSignatureCountLabel() {
		return signatureCountLabel;
	}

	public boolean isVisibleSignature() {
		return visibleSignature;
	}

	public static class Builder {
		private Path unsignedPath;
		private Path barcodeImage;
		private BarcodeType barcodeType;
		private String downloadText;
		private String pageCountLabel;
		private String mark;
		private String subMarkLeft;
		private String subMarkRight;
		private String signatureCountLabel;
		private boolean visibleSignature;
		private int totalSignatures;
		private List<PDFSignatureSignerData> signers;

		public Builder setUnsignedPath(Path unsignedPath) {
			this.unsignedPath = unsignedPath;
			return this;
		}

		public Builder setBarcodeImage(Path barcodeImage) {
			this.barcodeImage = barcodeImage;
			return this;
		}

		public Builder setBarcodeType(BarcodeType barcodeType) {
			this.barcodeType = barcodeType;
			return this;
		}

		public Builder setDownloadText(String downloadText) {
			this.downloadText = downloadText;
			return this;
		}

		public Builder setPageCountLabel(String pageCountLabel) {
			this.pageCountLabel = pageCountLabel;
			return this;
		}

		public Builder setMark(String mark) {
			this.mark = mark;
			return this;
		}

		public Builder setSubMarkLeft(String subMarkLeft) {
			this.subMarkLeft = subMarkLeft;
			return this;
		}

		public Builder setSubMarkRight(String subMarkRight) {
			this.subMarkRight = subMarkRight;
			return this;
		}

		public Builder setSignatureCountLabel(String signatureCountLabel) {
			this.signatureCountLabel = signatureCountLabel;
			return this;
		}

		public Builder setVisibleSignature(boolean visibleSignature) {
			this.visibleSignature = visibleSignature;
			return this;
		}

		public Builder setTotalSignatures(int totalSignatures) {
			this.totalSignatures = totalSignatures;
			return this;
		}

		public Builder setSigners(List<PDFSignatureSignerData> signers) {
			if (signers == null) {
				this.signers = Collections.emptyList();
			} else {
				this.signers = Collections.unmodifiableList(signers);
			}
			return this;
		}

		public PDFSignatureModel createPDFSignatureModel() {
			return new PDFSignatureModel(unsignedPath, barcodeImage, barcodeType, downloadText, pageCountLabel, mark, subMarkLeft, subMarkRight, signers,
					signatureCountLabel, visibleSignature, totalSignatures);
		}
	}
}
