package tech.espublico.pades.server.signers.service;

import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;

import tech.espublico.pades.server.helper.IOHelper;
import tech.espublico.pades.server.signers.sign.DigestAlgorithm;
import tech.espublico.pades.server.exceptions.OpenSignatureException;
import tech.espublico.pades.server.exceptions.OpenSignatureException.OpenSignatureExceptionReason;

public class PDFPrepareHelper {

	@Deprecated
	public static final float DEFAULT_BARCODE_HEIGHT = 8.89f; // 0.889cm - right 1cm margin
	@Deprecated
	public static final int BARCODE_TEXT_HEIGHT_PXS = 11; // Height down of the bard code (in pts)

	public static final int QR_DEFAULT_MARGIN = 1;

	public static final float SIGNATURE_FIELD_WIDTH = 29;
	public static final float SIGNATURE_FIELD_IMAGE_MAX_HEIGHT_PERCENT = 0.25f;
	public static final float SIGNATURE_FIELD_MARGIN = 2;
	public static final int SIGNATURE_FIELD_FONT_SIZE = 5;

	public static final int VERIFICATION_TEXT_FONT_SIZE = 6;
	public static final float VERIFICATION_TEXT_HEIGHT_PTS = 18; // 3 (lines) x 6 (line size) = 18 pts
	// Height in pts of the barcode (without text)
	public static final int MARGIN_BOTTOM = 30;
	public static final float BARCODE_HEIGHT_PTS = Utilities.millimetersToPoints(DEFAULT_BARCODE_HEIGHT) - BARCODE_TEXT_HEIGHT_PXS;
	public static final float MARGIN_RIGHT_PTS = Utilities.millimetersToPoints(10); // Right margin of 1.2cm
	// Margin of bar codes and CSV
	public static final float VERIFICATION_TEXT_MARGIN_RIGHT = VERIFICATION_TEXT_HEIGHT_PTS + MARGIN_RIGHT_PTS;
	public static final float BARCODE_MARGIN = BARCODE_HEIGHT_PTS + VERIFICATION_TEXT_MARGIN_RIGHT;
	public static final int BARCODE_HEIGHT = 370; // Height approximation of barcodes and CSV
	public static final float LABEL_WIDTH = 58; // Width of labels

	public static int CONTENTS_SIZE = 20480;

	public static final int SIGNATURES_PER_PAGE_HORIZONTAL = 3;
	public static final int SIGNATURES_PER_PAGE_VERTICAL = 3;

	public static final DigestAlgorithm DIGEST_ALG = DigestAlgorithm.SHA256;

	public static BaseFont loadFont(String font) throws IOException, DocumentException {
		return  BaseFont.createFont(font, BaseFont.CP1252, BaseFont.EMBEDDED);
	}

	public static boolean isHorizontal(PdfReader pdfReader) {
		Rectangle rect = pdfReader.getPageSizeWithRotation(1);
		float width = rect.getWidth();
		float height = rect.getHeight();

		boolean isHorizontal = false;
		if (height < width)
			isHorizontal = true;

		return isHorizontal;

	}

	public static Rectangle getRectangle(int posX, int posY, float width, float height, int rotation) {
		float llx = posX;
		float lly = posY;
		float urx = width;
		float ury = height;

		if (rotation % 180 == 90) {
			urx = llx + height - lly;
			//The size is square to ensure size of letters in 90 and 270 degree rotations.
		}

		return new Rectangle(llx, lly, urx, ury);
	}

	public static Point getPosition(int rectangleWidth, int rectangleHeight, int rotation, int size) {
		return getPosition(rectangleWidth, rectangleHeight, rotation, size, 0);
	}

	public static Point getPosition(int rectangleWidth, int rectangleHeight, int rotation, int size, int margin) {

		int posX = 0, posY = 0;

		if (rotation == 0) {
			posX = 0 + size;
			posY = 0 + margin;
		}
		if (rotation == 90) {
			posX = rectangleWidth - margin;
			posY = 0 + size;
		}
		if (rotation == 180) {
			posX = rectangleWidth - size;
			posY = rectangleHeight - margin;
		}
		if (rotation == 270) {
			posX = 0 + margin;
			posY = rectangleHeight - size;
		}

		return new Point(posX, posY);
	}

	public static PdfReader createPDFReader(Path pdf) throws OpenSignatureException {

		if (Files.notExists(pdf))
			throw new IllegalStateException("fileIn does not exists");

		PdfReader reader;
		InputStream is = null;
		try {
			is = Files.newInputStream(pdf, StandardOpenOption.READ);
			reader = new PdfReader(is);
		} catch (FileNotFoundException e) {
			throw new OpenSignatureException(e, OpenSignatureExceptionReason.DOCUMENT_INPUT_FILE_NOT_FOUND);
		} catch (BadPasswordException e) {
			throw new OpenSignatureException(e, OpenSignatureExceptionReason.PDF_PASSWORD_PROTECTED);
		} catch (IOException e) {
			throw new OpenSignatureException(e, OpenSignatureExceptionReason.DOCUMENT_INVALID_PDF_FILE);
		} finally {
			IOHelper.closeQuietly(is);
		}
		return reader;

	}
}
