package tech.espublico.pades.server.services.validation;

public class SignatureState {
	public enum Reason {
		INVALID,
		VALIDATION_ERROR,
		EMPTY,
		NOT_EQUALS,
	}

	private boolean isValid;
	private Reason reason;
	private String pdfSignatureName;
	private String signatureDate;
	private String signature;
	private String expectedSignature;
	private String validationErrorTrace;
	private boolean hasDssObject;

	public SignatureState() {

	}

	public SignatureState(String pdfSignatureName, String expectedSignature) {
		this.isValid = true;
		this.pdfSignatureName = pdfSignatureName;
		this.expectedSignature = expectedSignature;
	}

	public String getSignatureDate() {
		return signatureDate;
	}

	public void setSignatureDate(String signatureDate) {
		this.signatureDate = signatureDate;
	}

	public boolean isValid() {
		return isValid;
	}

	public void setValid(boolean valid) {
		isValid = valid;
	}

	public Reason getReason() {
		return reason;
	}

	public void setReason(Reason reason) {
		this.reason = reason;
	}

	public String getPdfSignatureName() {
		return pdfSignatureName;
	}

	public void setPdfSignatureName(String pdfSignatureName) {
		this.pdfSignatureName = pdfSignatureName;
	}

	public String getSignature() {
		return signature;
	}

	public void setSignature(String signature) {
		this.signature = signature;
	}

	public String getExpectedSignature() {
		return expectedSignature;
	}

	public void setExpectedSignature(String expectedSignature) {
		this.expectedSignature = expectedSignature;
	}

	public String getValidationErrorTrace() {
		return validationErrorTrace;
	}

	public void setValidationErrorTrace(String validationErrorTrace) {
		this.validationErrorTrace = validationErrorTrace;
	}

	public boolean isHasDssObject() {
		return hasDssObject;
	}

	public void setHasDssObject(boolean hasDssObject) {
		this.hasDssObject = hasDssObject;
	}
}
