package tech.espublico.pades.server.services.style;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import tech.espublico.pades.server.services.ConfigService;
import tech.espublico.pades.server.services.PropertyValidatorException;
import tech.espublico.pades.server.di.Service;
import tech.espublico.pades.server.di.ServiceLocator;

@Service
public class FontService {

	public static FontService instance() {
		return ServiceLocator.INSTANCE.getInstance(FontService.class);
	}

	private final Map<String, Path> fonts;

	private final Path font1;
	private final Path font2;
	private final Path font3;
	private final Path font4;
	private final Path font5;

	public FontService() throws PropertyValidatorException {
		Map<String, Path> fonts = new HashMap<>();

		String[] fontIds = ConfigService.instance().getStringArray("font.list");

		for (String fontId : fontIds) {
			Path fontPath = ConfigService.instance().getPath(String.format("font.%s.path", fontId));
			fonts.put(fontId, fontPath);
		}
		this.fonts = Collections.unmodifiableMap(fonts);

		this.font1 = loadFont("font.1");
		this.font2 = loadFont("font.2");
		this.font3 = loadFont("font.3");
		this.font4 = loadFont("font.4");
		this.font5 = loadFont("font.5");
	}

	private Path loadFont(String font) throws PropertyValidatorException {
		String fontKey = ConfigService.instance().getString(font);
		Path path = fonts.get(fontKey);

		if (path == null || Files.notExists(path))
			throw new PropertyValidatorException(String.format("No font config for key %s (font %s)", fontKey, font));

		return path;
	}

	private String getFont(Path path) {
		return path.toAbsolutePath().toString();
	}

	public String getFont1() {
		return this.getFont(this.font1);
	}

	public String getFont2() {
		return this.getFont(this.font2);
	}

	public String getFont3() {
		return this.getFont(this.font3);
	}

	public String getFont4() {
		return this.getFont(this.font4);
	}

	public String getFont5() {
		return this.getFont(this.font5);
	}
}
