package tech.espublico.pades.server.services.style;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import tech.espublico.pades.server.services.ConfigService;
import tech.espublico.pades.server.services.PropertyValidatorException;
import tech.espublico.pades.server.di.Service;
import tech.espublico.pades.server.di.ServiceLocator;

@Service
public class ColorProfileService {

	public static ColorProfileService instance() {
		return ServiceLocator.INSTANCE.getInstance(ColorProfileService.class);
	}

	private final Path colorProfilePath;

	public ColorProfileService() throws PropertyValidatorException {
		this.colorProfilePath = ConfigService.instance().getPath("color-profile.path");
		if (this.colorProfilePath == null || Files.notExists(this.colorProfilePath))
			throw new PropertyValidatorException(String.format("No file for color profile %s", this.colorProfilePath));
	}

	public String getColorProfile() {
		return this.colorProfilePath.toAbsolutePath().toString();
	}
}
