package tech.espublico.pades.server.services.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;

import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import tech.espublico.pades.server.services.ConfigService;
import tech.espublico.pades.server.services.PropertyValidatorException;
import tech.espublico.pades.server.di.Service;
import tech.espublico.pades.server.di.ServiceLocator;

@Service
public class FilesService {

	private static final Logger log = LoggerFactory.getLogger(FilesService.class);

	private static final String SYS_PROP_JAVA_IOTEMP = "java.io.tmpdir";

	public static FilesService instance() {
		return ServiceLocator.INSTANCE.getInstance(FilesService.class);
	}

	private Path tempApp;

	public FilesService() throws PropertyValidatorException, SchedulerException {
		File folder = new File(ConfigService.instance().getString("application.temp-files"));
		if (! folder.exists() || ! folder.canRead() || !  folder.canWrite())
			throw new PropertyValidatorException(String.format("Cannot read/write folder [%s]", folder.getAbsolutePath()));
		this.tempApp = folder.toPath();


	}

	public String getIotempJvm() {
		return System.getProperty(SYS_PROP_JAVA_IOTEMP);
	}

	public Path getIotempJvmPath() {
		return Paths.get(System.getProperty(SYS_PROP_JAVA_IOTEMP));
	}

	public Path getIoTempApp() {
		return tempApp;
	}

	public Path createTempFile() {
		try {
			return Files.createTempFile(getIoTempApp(), UUID.randomUUID().toString(), UUID.randomUUID().toString()).toAbsolutePath();

		} catch (IOException e) {
			throw new RuntimeIOException("Error creating application temporal files", e);
		}
	}
}
