package tech.espublico.pades.server.services.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class FilesCleanupJob implements Job {

	public static final String KEY = "clean-temp-app-files";

	private static final String JOB_DATA_MAX_AGE_CONFIG = "max-age-allowed";

	@Override
	public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
		JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();

		Path tempFiles = FilesService.instance().getIoTempApp();
		long maxAge = jobDataMap.getLongValue(JOB_DATA_MAX_AGE_CONFIG);

		try {
			FilesCleanupService.instance().cleanPathRecursive(tempFiles, maxAge);
		} catch (IOException e) {
			throw new JobExecutionException(e);
		}
	}

	public static JobDataMap map(Properties properties) {
		JobDataMap jobDataMap = new JobDataMap();
		jobDataMap.put(JOB_DATA_MAX_AGE_CONFIG, Long.valueOf(properties.getProperty(JOB_DATA_MAX_AGE_CONFIG)));
		return jobDataMap;
	}
}
