package tech.espublico.pades.server.services.pades;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import tech.espublico.pades.server.models.PDFSignerModel;
import tech.espublico.pades.server.signers.service.digest.hash.PDFHash;
import tech.espublico.pades.server.signers.service.digest.second.PDFSecondHash;

public class PadesSession {

	private final String sessionId;

	private PDFHash pdfHash;
	private PDFSecondHash pdfSecondHash;
	private List<Path> tempPaths = Collections.synchronizedList(new ArrayList<>());

	public PadesSession(String sessionId) {
		this.sessionId = sessionId;
	}

	public PDFHash getPdfHash() {
		return pdfHash;
	}

	public void setPdfHash(PDFHash pdfHash) {
		this.pdfHash = pdfHash;
	}

	public PDFSecondHash getPdfSecondHash() {
		return pdfSecondHash;
	}

	public void setPdfSecondHash(PDFSecondHash pdfSecondHash) {
		this.pdfSecondHash = pdfSecondHash;
	}

	public List<Path> getTempPaths() {
		return tempPaths;
	}

	public void setTempPaths(List<Path> tempPaths) {
		this.tempPaths = tempPaths;
	}
}
