package tech.espublico.pades.server.services.ocsp;

import java.security.cert.X509Certificate;
import java.util.Date;

import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPResp;

import tech.espublico.pades.server.helper.CheckArgument;
import tech.espublico.pades.server.helper.DateEx;
import tech.espublico.pades.server.models.CertificateOCSPConfiguration;

public class OCSPValidationModel {
	
	private CertificateOCSPConfiguration ocspConfiguration;

	private final X509Certificate certificate;

	private Date validAt = null;

	private X509Certificate issuerCertificate;

	private OCSPReq validationRequest;
	
	private OCSPResp validationResponse;

	public OCSPValidationModel(X509Certificate cert) {
		CheckArgument.notNull("certificate", cert);
		this.certificate = cert;
	}
	
	public OCSPValidationModel validAtTime(Date validAt) {
		this.validAt = validAt;
		return this;
	}

	public OCSPValidationModel withOCSPServer(CertificateOCSPConfiguration ocspConfiguration) {
		this.ocspConfiguration = ocspConfiguration;
		return this;
	}

	public OCSPValidationModel withIssuerCertificate(X509Certificate certificate) {
		this.issuerCertificate = certificate;
		return this;
	}

	public X509Certificate getCertificate() {
		return certificate;
	}

	public Date getValidAt() {
		if (validAt == null)
			validAt = DateEx.getDateGMT0();
		return validAt;
	}

	public X509Certificate getIssuerCertificate() {
		return issuerCertificate;
	}

	public OCSPResp getValidationResponse() {
		return validationResponse;
	}

	public void setValidationResponse(OCSPResp validationResponse) {
		this.validationResponse = validationResponse;
	}

	public CertificateOCSPConfiguration getOcspConfiguration() {
		return ocspConfiguration;
	}

	public OCSPReq getValidationRequest() {
		return validationRequest;
	}

	public void setValidationRequest(OCSPReq validationRequest) {
		this.validationRequest = validationRequest;
	}

}
