package tech.espublico.pades.server.services.ocsp;

import java.net.URL;

import tech.espublico.pades.server.helper.CheckArgument;
import tech.espublico.pades.server.models.CertificateOCSPConfiguration;

public class OCSPHttpClientException extends OCSPValidationException {

	private static final long serialVersionUID = 1L;

	private final CertificateOCSPConfiguration serverConfiguration;
	
	private final boolean canRetry;

	public OCSPHttpClientException(CertificateOCSPConfiguration serverConfiguration, String message, boolean canRetry) {
		super(OCSPValidationExceptionReason.HTTP_CLIENT_ERROR, message);
		CheckArgument.notNull("OCSP Http client", serverConfiguration);
		this.serverConfiguration = serverConfiguration;
		this.canRetry = canRetry;
	}

	public OCSPHttpClientException(CertificateOCSPConfiguration serverConfiguration, String message, boolean canRetry, Throwable cause) {
		super(OCSPValidationExceptionReason.HTTP_CLIENT_ERROR, message, cause);
		CheckArgument.notNull("OCSP Http client", serverConfiguration);
		this.serverConfiguration = serverConfiguration;
		this.canRetry = canRetry;
	}

	public URL getOcspServerUrl() {
		return this.serverConfiguration.getServerURL();
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(super.toString());
		sb.append("\nocsp server url: ").append(getOcspServerUrl().toString());
		return sb.toString();
	}

	public boolean isCanRetry() {
		return canRetry;
	}

}
