package tech.espublico.pades.server.services.gson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

public class X509CertificateTypeAdapter implements JsonSerializer<X509Certificate>, JsonDeserializer<X509Certificate> {
	private final ByteArrayTypeAdapter byteArrayTypeAdapter;
	private final CertificateFactory certificateFactory;

	public X509CertificateTypeAdapter() throws CertificateException {
		this.byteArrayTypeAdapter = new ByteArrayTypeAdapter();
		this.certificateFactory = CertificateFactory.getInstance("X.509");
	}

	@Override
	public X509Certificate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
		byte[] bytes = this.byteArrayTypeAdapter.deserialize(json, typeOfT, context);
		try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes)) {
			return (X509Certificate) this.certificateFactory.generateCertificate(byteArrayInputStream);
		} catch (CertificateException | IOException e) {
			throw new JsonParseException(e);
		}
	}

	@Override
	public JsonElement serialize(X509Certificate src, Type typeOfSrc, JsonSerializationContext context) {
		try {
			return this.byteArrayTypeAdapter.serialize(src.getEncoded(), typeOfSrc, context);
		} catch (CertificateEncodingException e) {
			throw new RuntimeException(e);
		}
	}
}
