package tech.espublico.pades.server.services.gson;

import java.lang.reflect.Type;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

public class CertificateTypeAdapter implements JsonSerializer<Certificate>, JsonDeserializer<Certificate> {
	private final X509CertificateTypeAdapter certificateTypeAdapter;

	public CertificateTypeAdapter() throws CertificateException {
		this.certificateTypeAdapter = new X509CertificateTypeAdapter();
	}


	@Override
	public Certificate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
		return this.certificateTypeAdapter.deserialize(json, typeOfT, context);
	}

	@Override
	public JsonElement serialize(Certificate src, Type typeOfSrc, JsonSerializationContext context) {
		return certificateTypeAdapter.serialize((X509Certificate) src, typeOfSrc, context);
	}
}
