package tech.espublico.pades.server.services;

import java.io.File;

import tech.espublico.pades.server.di.Service;
import tech.espublico.pades.server.di.ServiceLocator;

@Service
public class SystemService {

	public static SystemService instance() {
		return ServiceLocator.INSTANCE.getInstance(SystemService.class);
	}

	public String getHostId() {
		String property = System.getProperty("hostname");
		if (property == null)
			property = "unknown";
		return property;
	}
	
	public String getSystemVersion() {
		return getHostId();
	}

	public File getTemporalDirectory() {
		return getSystemTmpDir();
	}
	
	public File getApplicationTemporalDirectory() {
		return getSystemTmpDir();
	}

	private File getSystemTmpDir() {
		String tmpDirPath = System.getProperty("java.io.tmpdir");
		File tmpdir = new File(tmpDirPath);
		return tmpdir;
	}
}
