package tech.espublico.pades.server.services;

import java.io.File;

public class PropertyValidatorException extends Exception {

	public PropertyValidatorException(String key) {
		super(String.format("Error in key [%s]", key));
	}

	public PropertyValidatorException(String key, Exception e) {
		super(String.format("Cannot read key [%s]: %s", key, e.getMessage()), e);
	}

	public PropertyValidatorException(String message, File file) {
		super(String.format("Cannot read property file [%s]", file.getAbsolutePath()));
	}
}
