package tech.espublico.pades.server.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import tech.espublico.pades.server.di.ServiceLocator;
import tech.espublico.pades.server.rest.RoutesService;
import tech.espublico.pades.server.rest.auth.AuthService;
import tech.espublico.pades.server.rest.validation.ValidationRoutesService;
import tech.espublico.pades.server.services.ocsp.OCSPValidationService;
import tech.espublico.pades.server.services.pades.PadesService;
import tech.espublico.pades.server.services.scheduler.SchedulerService;
import tech.espublico.pades.server.services.storage.FilesCleanupService;
import tech.espublico.pades.server.services.storage.FilesService;
import tech.espublico.pades.server.services.style.ColorProfileService;
import tech.espublico.pades.server.services.style.FontService;
import tech.espublico.pades.server.services.validation.SignatureValidationService;
import tech.espublico.pades.server.signers.service.digest.hash.PDFHashService;
import tech.espublico.pades.server.signers.service.digest.second.PDFSecondHashService;
import tech.espublico.pades.server.signers.service.prepare.PDFPrepareForSignatureService;
import tech.espublico.pades.server.signers.service.sign.PDFSignService;
import tech.espublico.pades.server.signers.sign.ocsp.OCSPService;
import tech.espublico.pades.server.signers.sign.timestamp.TimestamperService;

/**
 * Registrarion for the service locator of all services needed.
 */
public class PadesComponents {

	/**
	 * @return list of all the services needed to register
	 */
	public static List<Class<?>> get() {
		List<Class<?>> classes = new ArrayList<>();

		classes.add(GsonService.class);

		classes.add(FontService.class);
		classes.add(ColorProfileService.class);

		classes.add(RoutesService.class);
		classes.add(AuthService.class);
		classes.add(SystemService.class);

		classes.add(PadesService.class);

		classes.add(PDFPrepareForSignatureService.class);
		classes.add(PDFHashService.class);
		classes.add(PDFSecondHashService.class);
		classes.add(PDFSignService.class);

		classes.add(OCSPService.class);
		classes.add(TimestamperService.class);

		classes.add(SchedulerService.class);

		classes.add(FilesService.class);
		classes.add(FilesCleanupService.class);

		classes.add(ValidationRoutesService.class);
		classes.add(SignatureValidationService.class);

		return Collections.unmodifiableList(classes);
	}

	/**
	 * @return replacements of all the service providers
	 */
	public static List<Pair<Class<?>, Class<?>>> replaces() {
		List<Pair<Class<?>, Class<?>>> replaces = new ArrayList<>();
		replaces.add(Pair.of(OCSPService.class, OCSPValidationService.class));
		replaces.add(Pair.of(TimestamperService.class, tech.espublico.pades.server.services.timestamper.TimestamperService.class));
		return Collections.unmodifiableList(replaces);
	}

	/**
	 * Registration on the service locator of all the services listed and the replacement providers
	 */
	public static void register() {
		ServiceLocator.INSTANCE.registerAll(get());
		for (Pair<Class<?>, Class<?>> replacement : replaces()) {
			ServiceLocator.INSTANCE.replace(replacement.getLeft(), replacement.getRight());
		}
	}
}
