package tech.espublico.pades.server.services;

import java.util.concurrent.CountDownLatch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppUtils {
	private static final Logger log = LoggerFactory.getLogger(AppUtils.class);

	/**
	 * Starts and awaits the stop of the app.
	 *
	 * @param appName
	 * 		name of the app to launch used to show in the log messages
	 * @param shutdown
	 * 		actions to execute when stopping the server
	 */
	public static void waitToExit(String appName, Runnable shutdown) {
		log.info("------------------------------------------------------ {} Started !! ------------------------------------------------------", appName);
		final CountDownLatch countRun = new CountDownLatch(1);
		Runtime.getRuntime().addShutdownHook(new Thread(() -> {
			shutdown.run();
			countRun.countDown();
		}));

		try {
			countRun.await();
		} catch (Exception e) {
			log.error("Error waiting to interruption event", e);
			throw new RuntimeException(e);
		}

		log.info("------------------------------------------------------ Stop {} Finished !! ------------------------------------------------------", appName);
	}
}
