package tech.espublico.pades.server.rest.validation;

import java.nio.file.Path;
import java.util.List;

import spark.Spark;
import tech.espublico.pades.server.di.Service;
import tech.espublico.pades.server.di.ServiceLocator;
import tech.espublico.pades.server.exceptions.OpenSignatureException;
import tech.espublico.pades.server.exceptions.OpenSignatureException.OpenSignatureExceptionReason;
import tech.espublico.pades.server.rest.PadesRoute;
import tech.espublico.pades.server.rest.request.SignRequest;
import tech.espublico.pades.server.rest.request.SignerRequest;
import tech.espublico.pades.server.services.ConfigService;
import tech.espublico.pades.server.services.GsonService;
import tech.espublico.pades.server.services.PropertyValidatorException;
import tech.espublico.pades.server.services.validation.SignatureValidationService;
import tech.espublico.pades.server.services.validation.ValidationException;
import tech.espublico.pades.server.services.validation.ValidationResponse;

@Service
public class ValidationRoutesService {

	public static ValidationRoutesService instance() {
		return ServiceLocator.INSTANCE.getInstance(ValidationRoutesService.class);
	}

	private final SignatureValidationService signatureValidationService;
	private final boolean isIntegrationTest;

	public ValidationRoutesService() throws PropertyValidatorException {
		this.signatureValidationService = SignatureValidationService.instance();
		this.isIntegrationTest = ConfigService.instance().getBool("pades-server.integration-test.mode.active", false);
	}

	public void register() {
		if (this.isIntegrationTest) {
			Spark.post("/validate", new PadesRoute<ValidationRequest, ValidationResponse>(ValidationRequest.class) {
				@Override
				public ValidationResponse handle(String sessionId, ValidationRequest request) throws OpenSignatureException {
					Path path = request.getPath();
					List<String> expectedSignatures = request.getExpectedSignatures();
					try {
						return signatureValidationService.validate(path, expectedSignatures);
					} catch (ValidationException e) {
						throw new OpenSignatureException("Error validating", e, OpenSignatureExceptionReason.UNKNOWN);
					}
				}
			});
		}
	}
}
