package tech.espublico.pades.server.rest.results;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class SignerResponse<T> {

	public T model;
	public ErrorResult errorResult;

	public T getModel() {
		return model;
	}

	public void setModel(T model) {
		this.model = model;
	}

	public ErrorResult getErrorResult() {
		return errorResult;
	}

	public void setErrorResult(ErrorResult errorResult) {
		this.errorResult = errorResult;
	}

	public static class ResponseOf<T> implements ParameterizedType {

		private final Class<T> wrapped;

		public ResponseOf(Class<T> wrapped) {
			this.wrapped = wrapped;
		}

		@Override
		public Type[] getActualTypeArguments() {
			return new Type[] { this.wrapped };
		}

		@Override
		public Type getRawType() {
			return SignerResponse.class;
		}

		@Override
		public Type getOwnerType() {
			return null;
		}
	}
}
