package tech.espublico.pades.server.rest.results;

import java.io.Serializable;

/**
 * Second hash result class, contains the bytes and the attributes to sign<br/>
 * <br/>
 * This class is created by the PDFSigner.getSecondHashToSign method
 */
public class SecondHashResult implements Serializable {

	private static final long serialVersionUID = 1L;

	private byte[] bytesToSign;

	//Ponemos el sessionId que lo ha generado, el servidor tiene el dato
	//guardado en la sesion
	private String signedAttributes;

	public SecondHashResult(byte[] hash, String signedAttributes) {
		this.bytesToSign = hash;
		this.signedAttributes = signedAttributes;
	}

	public byte[] getHash() {
		return bytesToSign;
	}

	public String getSignedAttributes() {
		return signedAttributes;
	}
}