package tech.espublico.pades.server.rest.results;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;

import tech.espublico.pades.server.exceptions.OpenSignatureException;
import tech.espublico.pades.server.exceptions.OpenSignatureException.OpenSignatureExceptionReason;

public class ErrorResult {

	public enum ExceptionType {
		SIGNATURE,
		UNKNOWN,
	}

	public ExceptionType exceptionType;

	private String cause;
	private String message;
	private OpenSignatureExceptionReason reason;
	private URL ocspServer;

	private String trace;

	public ErrorResult(OpenSignatureException e) {
		this((Throwable) e);
		this.exceptionType = ExceptionType.SIGNATURE;
		this.reason = e.getReason();
		this.ocspServer = e.getOcspServer();
	}

	public ErrorResult(Throwable t) {
		this.message = t.getMessage();
		this.cause = t.getClass().getCanonicalName();
		this.exceptionType = ExceptionType.UNKNOWN;
		this.reason = OpenSignatureExceptionReason.SERVER_ERROR;

		try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();//
				PrintStream printStream = new PrintStream(byteArrayOutputStream);) {
			t.printStackTrace(printStream);
			this.trace = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public ExceptionType getExceptionType() {
		return exceptionType;
	}

	public void setExceptionType(ExceptionType exceptionType) {
		this.exceptionType = exceptionType;
	}

	public String getTrace() {
		return trace;
	}

	public void setTrace(String trace) {
		this.trace = trace;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public OpenSignatureExceptionReason getReason() {
		return reason;
	}

	public void setReason(OpenSignatureExceptionReason reason) {
		this.reason = reason;
	}

	public URL getOcspServer() {
		return ocspServer;
	}

	public void setOcspServer(URL ocspServer) {
		this.ocspServer = ocspServer;
	}
}
