package tech.espublico.pades.server.rest.request;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class SignerRequest<T> {
	T model;

	public SignerRequest() {
	}

	public SignerRequest(T model) {
		this.model = model;
	}

	public T getModel() {
		return model;
	}

	public void setModel(T model) {
		this.model = model;
	}

	public static class RequestOf<T> implements ParameterizedType {

		private final Class<T> wrapped;

		public RequestOf(Class<T> wrapped) {
			this.wrapped = wrapped;
		}

		@Override
		public Type[] getActualTypeArguments() {
			return new Type[] { this.wrapped };
		}

		@Override
		public Type getRawType() {
			return SignerRequest.class;
		}

		@Override
		public Type getOwnerType() {
			return null;
		}
	}
}
