package tech.espublico.pades.server.rest.auth;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import spark.Filter;
import spark.Request;
import spark.Response;

/**
 * Validates the simple jwt token (just the session id and the resource path).
 * The first step to validate the request. There is a need to validate further
 * with the content of the request if it's a post request.
 *
 * Both validations are needed.
 */
public class SimpleAuthFilter implements Filter {

	private static final Logger log = LoggerFactory.getLogger(SimpleAuthFilter.class);

	private final AuthService authService;

	public SimpleAuthFilter() {
		this.authService = AuthService.instance();
	}

	@Override
	public void handle(Request request, Response response) throws Exception {
		log.debug("Authenticatin request {}", request.url());
		this.authService.validateWithoutData(request);
	}
}
