package tech.espublico.pades.server.rest.auth;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import spark.Filter;
import spark.Request;
import spark.Response;

public class PostAuthFilter implements Filter {

	private static final Logger log = LoggerFactory.getLogger(PostAuthFilter.class);

	private final AuthService authService;

	public PostAuthFilter() {
		this.authService = AuthService.instance();
	}

	@Override
	public void handle(Request request, Response response) throws Exception {
		log.debug("Auth post request {}", request.url());
		this.authService.validatePostData(request);
	}
}
