package tech.espublico.pades.server.rest.auth;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;

public class AuthValidationModel<M> {

	public final String sessionId;
	public final URL uri;
	public final Path path;
	public final M model;

	public AuthValidationModel(String sessionId, String uri) {
		this(sessionId, uri, null, null);
	}

	public AuthValidationModel(String sessionId, String uri, M model) {
		this(sessionId, uri, null, model);
	}

	public AuthValidationModel(String sessionId, String uri, Path path) {
		this(sessionId, uri, path, null);
	}

	public AuthValidationModel(String sessionId, String uri, Path path, M model) {
		this.sessionId = sessionId;
		try {
			this.uri = new URL(uri);
		} catch (MalformedURLException e) {
			throw new RuntimeException(e);
		}
		this.path = path;
		this.model = model;
	}

	public String getSessionId() {
		return sessionId;
	}

	public URL getUri() {
		return uri;
	}

	public Path getPath() {
		return path;
	}

	public M getModel() {
		return model;
	}
}
