package tech.espublico.pades.server.rest;

import org.eclipse.jetty.http.HttpStatus;

import spark.Request;
import spark.Response;
import spark.Route;
import spark.Spark;
import tech.espublico.pades.server.rest.results.SignerResponse;
import tech.espublico.pades.server.services.GsonService;

public class StatusRoute implements Route {

	private final String statusOk;

	public StatusRoute() {
		SignerResponse<Boolean> ok = new SignerResponse<>();
		ok.setModel(true);
		this.statusOk =	GsonService.instance().toJson(ok);

	}

	@Override
	public Object handle(Request request, Response response) throws Exception {
		Spark.halt(HttpStatus.OK_200, statusOk);
		return null;
	}
}
