package tech.espublico.pades.server.rest;

import org.eclipse.jetty.http.HttpStatus;

import spark.Request;
import spark.Response;
import spark.Route;
import tech.espublico.pades.server.exceptions.OpenSignatureException;
import tech.espublico.pades.server.rest.request.SignerRequest;
import tech.espublico.pades.server.rest.request.SignerRequest.RequestOf;
import tech.espublico.pades.server.rest.results.SignerResponse;
import tech.espublico.pades.server.services.GsonService;

public abstract class PadesRoute<R, V> implements Route {

	private final RequestOf<R> requestOf;

	public PadesRoute(Class<R> clazz) {
		this.requestOf = new RequestOf<>(clazz);
	}

	@Override
	public Object handle(Request request, Response response) throws Exception {
		String sessionId = request.headers(PadesServerHeaders.SESSION_ID_HEADER);

		SignerRequest<R> signerRequest = GsonService.instance().fromJson(request.body(), this.requestOf);

		V resp = handle(sessionId, signerRequest.getModel());
		SignerResponse<V> signerResponse = new SignerResponse<>();
		signerResponse.setModel(resp);

		response.status(HttpStatus.OK_200);
		return GsonService.instance().toJson(signerResponse);
	}

	public abstract V handle(String sessionId, R request) throws OpenSignatureException;
}
