package tech.espublico.pades.server.models;

import java.io.Serializable;
import java.net.URL;
import java.security.cert.X509Certificate;

public class TimestamperData implements Serializable {

	private static final long serialVersionUID = 1L;

	private String code;
	private String name;
	private String user;
	private String password;
	private URL server;
	private URL OCSPServer;
	private X509Certificate cert;
	private boolean enabled;
	
	public String getUser() {
		return user;
	}

	public TimestamperData setUser(String user) {
		this.user = user;
		return this;
	}

	public String getPassword() {
		return password;
	}

	public TimestamperData setPassword(String password) {
		this.password = password;
		return this;
	}

	public URL getServer() {
		return server;
	}

	public TimestamperData setServer(URL server) {
		this.server = server;
		return this;
	}

	public URL getOCSPServer() {
		return OCSPServer;
	}

	public TimestamperData setOCSPServer(URL server) {
		OCSPServer = server;
		return this;
	}

	public TimestamperData setName(String name) {
		this.name = name;
		return this;
	}

	public String getName() {
		return name;
	}

	public TimestamperData setEnabled(boolean enabled) {
		this.enabled = enabled;
		return this;
	}

	public boolean isEnabled() {
		return enabled;
	}
	
	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return code;
	}

	public X509Certificate getCert() {
		return cert;
	}

	public void setCert(X509Certificate cert) {
		this.cert = cert;
	}

	@Override
	public String toString() {
		return String.format("TimestamperData={server=%s user=%s ocsp=%s}", //
				this.server, //
				this.user, //
				this.OCSPServer);
	}

}
