package tech.espublico.pades.server.models;

import java.io.File;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.util.Calendar;
import java.util.List;

public class PDFSignerModel implements Serializable {

	private static final long serialVersionUID = 1L;

	public enum ByteMode{
		HASH(null), // los bytes a firmar han sido pasados por el digest
		RAW("SHA256withRSA"); // los bytes a firmar estan sin tratar

		// solo aplica al modo RAW
		private String signatureAlgorithm;
		ByteMode(String signatureAlgorithm){
			this.signatureAlgorithm = signatureAlgorithm;
		}

		public String getSignatureAlgorithm() {
			return signatureAlgorithm;
		}
	}

	private CertificateOCSPConfiguration signerOCSPConfiguration = null;

	private TimestamperData timestamperData;
	private TimestamperData backupTimestamperData;
	private File fileIn = null;
	private String reason = null;
	private String location = null;
	private String contactInfo = null;
	private int signatureNumber = 0;
	private int totalSignatures = 0;
	private File signatureImage = null;
	private File barcodeImage = null;
	private BarcodeType barcodeType = null;
	private String signerData = null;
	private Certificate[] certs = null;
	private boolean certifyNoChangesAllowed = false;
	private String downloadUrl = null;
	private String downloadText = null;
	private String username = null;
	private String userCharge = null;
	private String organizationData = null;
	private String mark = null;
	private String subMarkLeft = null;
	private String subMarkRight = null;
	private List<PDFSignatureSignerData> signers = null;
	private boolean started = false;
	private String validationCode = null;
	private boolean validateSignature;
	private String signatureDate = null;
	private String signatureCountLabel = null;
	private String pageCountLabel = null;
	private Calendar signDate;
	private boolean visibleSignature = true;
	private ByteMode byteMode = ByteMode.HASH;

	public File getFileIn() {
		return fileIn;
	}

	public void setFileIn(File fileIn) {
		this.fileIn = fileIn;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public String getContactInfo() {
		return contactInfo;
	}

	public void setContactInfo(String contactInfo) {
		this.contactInfo = contactInfo;
	}

	public int getSignatureNumber() {
		return signatureNumber;
	}

	public void setSignatureNumber(int signatureNumber) {
		this.signatureNumber = signatureNumber;
	}

	public int getTotalSignatures() {
		return totalSignatures;
	}

	public void setTotalSignatures(int totalSignatures) {
		this.totalSignatures = totalSignatures;
	}

	public File getSignatureImage() {
		return signatureImage;
	}

	public void setSignatureImage(File signatureImage) {
		this.signatureImage = signatureImage;
	}

	public File getBarcodeImage() {
		return barcodeImage;
	}

	public void setBarcodeImage(File barcodeImage) {
		this.barcodeImage = barcodeImage;
	}

	public BarcodeType getBarcodeType() {
		return barcodeType;
	}

	public void setBarcodeType(final BarcodeType barcodeType) {
		this.barcodeType = barcodeType;
	}

	public String getSignerData() {
		return signerData;
	}

	public void setSignerData(String signerData) {
		this.signerData = signerData;
	}

	public Certificate[] getCerts() {
		return certs;
	}

	public void setCerts(Certificate[] certs) {
		this.certs = certs;
	}

	public boolean isCertifyNoChangesAllowed() {
		return certifyNoChangesAllowed;
	}

	public void setCertifyNoChangesAllowed(boolean certifyNoChangesAllowed) {
		this.certifyNoChangesAllowed = certifyNoChangesAllowed;
	}

	public String getDownloadUrl() {
		return downloadUrl;
	}

	public void setDownloadUrl(String downloadUrl) {
		this.downloadUrl = downloadUrl;
	}

	public String getDownloadText() {
		return downloadText;
	}

	public void setDownloadText(String downloadText) {
		this.downloadText = downloadText;
	}

	public String getUserName() {
		return username;
	}

	public void setUserName(String userName) {
		this.username = userName;
	}

	public String getOrganizationData() {
		return organizationData;
	}

	public void setOrganizationData(String organizationData) {
		this.organizationData = organizationData;
	}

	public String getMark() {
		return mark;
	}

	public void setMark(String mark) {
		this.mark = mark;
	}

	public List<PDFSignatureSignerData> getSigners() {
		return signers;
	}

	public void setSigners(List<PDFSignatureSignerData> list) {
		this.signers = list;
	}

	public boolean isStarted() {
		return started;
	}

	public void setStarted(boolean started) {
		this.started = started;
	}

	public String getValidationCode() {
		return validationCode;
	}

	public void setValidationCode(String validationCode) {
		this.validationCode = validationCode;
	}

	public boolean isValidateSignature() {
		return validateSignature;
	}

	public void setValidateSignature(boolean validateSignature) {
		this.validateSignature = validateSignature;
	}

	public void setSignatureDate(String signatureDate) {
		this.signatureDate = signatureDate;
	}

	public String getSignatureDate() {
		return signatureDate;
	}

	public void setSignatureCountLabel(String signatureCountLabel) {
		this.signatureCountLabel = signatureCountLabel;
	}

	public String getSignatureCountLabel() {
		return signatureCountLabel;
	}

	public void setPageCountLabel(String pageCountLabel) {
		this.pageCountLabel = pageCountLabel;
	}

	public String getPageCountLabel() {
		return pageCountLabel;
	}

	public String getUserCharge() {
		return userCharge;
	}

	public void setUserCharge(String userCharge) {
		this.userCharge = userCharge;
	}

	public String getSubMarkLeft() {
		return subMarkLeft;
	}

	public void setSubMarkLeft(String subMarkLeft) {
		this.subMarkLeft = subMarkLeft;
	}

	public String getSubMarkRight() {
		return subMarkRight;
	}

	public void setSubMarkRight(String subMarkRight) {
		this.subMarkRight = subMarkRight;
	}

	public Calendar getSignDate() {
		return signDate;
	}

	public void setSignDate(Calendar signDate) {
		this.signDate = signDate;
	}

	public ByteMode getByteMode() {
		return byteMode;
	}

	public void setByteMode(ByteMode byteMode) {
		this.byteMode = byteMode;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("signerOCSPConfiguration = ").append(this.signerOCSPConfiguration).append("\n");
		sb.append("serverTimestamp = ").append(this.timestamperData).append("\n");
		sb.append("backupServerTimestamp = ").append(this.backupTimestamperData).append("\n");
		sb.append("fileIn = ").append(fileIn).append("\n");
		sb.append("reason = ").append(reason).append("\n");
		sb.append("location = ").append(location).append("\n");
		sb.append("contactInfo = ").append(contactInfo).append("\n");
		sb.append("signatureNumber = ").append(signatureNumber).append("\n");
		sb.append("totalSignatures = ").append(totalSignatures).append("\n");
		sb.append("signatureImage = ").append(signatureImage).append("\n");
		sb.append("barcodeImage = ").append(barcodeImage).append("\n");
		sb.append("signerData = ").append("GONE, get through certs").append("\n");
		sb.append("signDate = ").append(this.signDate).append("\n");
		sb.append("certs = ").append(certs).append("\n");
		sb.append("certifyNoChangesAllowed = ").append(certifyNoChangesAllowed).append("\n");
		sb.append("downloadText = ").append(downloadText).append("\n");
		sb.append("userName = ").append(username).append("\n");
		sb.append("userCharge = ").append(userCharge).append("\n");
		sb.append("mark = ").append(mark).append("\n");
		sb.append("subMarkLeft = ").append(subMarkLeft).append("\n");
		sb.append("subMarkLeft = ").append(subMarkRight).append("\n");
		sb.append("signers = ").append(signers).append("\n");
		sb.append("validationCode = ").append(validationCode).append("\n");
		sb.append("signatureDateLabel = ").append(signatureDate).append("\n");
		sb.append("signatureCountLabel = ").append(signatureCountLabel).append("\n");
		sb.append("pageCountLabel = ").append(pageCountLabel).append("\n");
		sb.append("byteMode = ").append(byteMode.name()).append("\n");

		return sb.toString();
	}

	public CertificateOCSPConfiguration getSignerOCSPConfiguration() {
		return signerOCSPConfiguration;
	}

	public void setSignerOCSPConfiguration(CertificateOCSPConfiguration signerOCSPConfiguration) {
		this.signerOCSPConfiguration = signerOCSPConfiguration;
	}

	public boolean isVisibleSignature() {
		return visibleSignature;
	}

	public void setVisibleSignature(boolean visibleSignature) {
		this.visibleSignature = visibleSignature;
	}

	public TimestamperData getTimestamperData() {
		return timestamperData;
	}

	public void setTimestamperData(TimestamperData timestamperData) {
		this.timestamperData = timestamperData;
	}

	public TimestamperData getBackupTimestamperData() {
		return backupTimestamperData;
	}

	public void setBackupTimestamperData(TimestamperData backupTimestamperData) {
		this.backupTimestamperData = backupTimestamperData;
	}

}
