package tech.espublico.pades.server.models;

import java.io.File;
import java.io.Serializable;
import java.security.cert.X509Certificate;

public class PDFSignedDocumentModel implements Serializable {

	private final File signedPdfFile;
	private final X509Certificate signerCertificate;

	public PDFSignedDocumentModel(File signedFile, X509Certificate signer) {
		this.signedPdfFile = signedFile;
		this.signerCertificate = signer;
	}

	public File getSignedPdfFile() {
		return signedPdfFile;
	}

	public X509Certificate getSignerCertificate() {
		return signerCertificate;
	}
}
