package tech.espublico.pades.server.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Wrapps a {@link ByteArrayOutputStream} and gives easy acces as an {@link InputStream} to the written data.
 */
public class WriteReadOutputStream extends OutputStream {

	private final ByteArrayOutputStream byteArrayOutputStream;

	public WriteReadOutputStream() {
		this(32);
	}

	public WriteReadOutputStream(int expectedSize) {
		this.byteArrayOutputStream = new ByteArrayOutputStream(expectedSize);
	}

	@Override
	public void write(int i) throws IOException {
		this.byteArrayOutputStream.write(i);
	}

	/**
	 * Closes the strams and generates an {@link InputStream} with the written data
	 *
	 * @return an {@link InputStream} with the written data
	 *
	 * @throws IOException
	 * 		in case of not being able to close the stream
	 */
	public InputStream getInputStream() throws IOException {
		this.close();
		return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
	}

	public long size() {
		return this.byteArrayOutputStream.size();
	}

	@Override
	public void close() throws IOException {
		this.byteArrayOutputStream.close();
	}
}
