package tech.espublico.pades.server.helper;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import tech.espublico.pades.server.services.SystemService;

public class IOHelper {

	private static final Logger log = LoggerFactory.getLogger(IOHelper.class);

	public static void closeQuietly(Closeable closeable) {
		IOHelper.closeQuietly((AutoCloseable) closeable);
	}

	public static void closeQuietly(AutoCloseable closeable) {
		try {
			if (closeable != null)
				closeable.close();
		} catch (Exception e) {
			log.warn("Error while closing stream", e);
		}
	}

	public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
		byte[] buf = new byte[4096];
		long count = 0;

		int c;
		for (; (c = inputStream.read(buf)) > -1; count += c) {
			outputStream.write(buf, 0, c);
		}

		return count;
	}

	public static WriteReadOutputStream newSmartOutputStream() {
		return new WriteReadOutputStream();
	}

	public static WriteReadOutputStream newSmartOutputStream(int size) throws IOException {
		return new WriteReadOutputStream(size);
	}
}
