package tech.espublico.pades.server.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FilesHelper {

	public static Path toPath(File file) {
		if (file == null) {
			return null;
		}
		return file.toPath();
	}

	public static boolean exists(Path path) {
		if (path == null)
			return false;

		return Files.exists(path);
	}

	public static boolean exists(File file) {
		if (file == null)
			return false;

		return FilesHelper.exists(file.toPath());
	}

	public static boolean notExists(File file) {
		return ! FilesHelper.exists(file);
	}

	public static InputStream open(Path path) throws IOException {
		return Files.newInputStream(path, StandardOpenOption.READ);
	}

	public static InputStream open(File file) throws IOException {
		return FilesHelper.open(file.toPath());
	}

	public static OutputStream openWrite(Path path) throws IOException {
		return Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
	}

	public static OutputStream openWrite(File file) throws IOException {
		return FilesHelper.openWrite(file.toPath());
	}

	public static File createTempFile(String prefix, String ext) throws IOException {
		return Files.createTempFile(prefix, ext).toFile();
	}

	public static InputStream newInputStream(String file) throws IOException {
		return FilesHelper.newInputStream(new File(file));

	}

	public static InputStream newInputStream(File file) throws IOException {
		return FilesHelper.open(file);
	}

	public static OutputStream newOutputStream(File file) throws IOException {
		return FilesHelper.openWrite(file);
	}
}
