package tech.espublico.pades.server.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayHelper {

	private static final int COPY_BUFFER_SIZE = 1024;

	public static byte[] streamToByteArray(InputStream inputStream) throws IOException {
		if (inputStream == null)
			return null;


		try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(COPY_BUFFER_SIZE)) {

			IOHelper.copy(inputStream, byteArrayOutputStream);

			byteArrayOutputStream.close();
			return byteArrayOutputStream.toByteArray();

		}
	}
}
