package tech.espublico.pades.server.exceptions;

import java.net.URL;

/**
 * Exposed error for any cause in the process of adding the signature to a pdf file
 */
public class OpenSignatureException extends Exception {

	public enum OpenSignatureExceptionReason {
		PDF_RESTRICTED, //
		PDF_PASSWORD_PROTECTED, //
		OCSP_INVALID, //
		OCSP_CLIENT_ERROR, //
		OCSP_UNKNOWN, //
		PKC7_INVALID, //
		PDF_IO_ERROR, //
		HASH_INVALID_DER_SET, //
		HASH_GET_BYTES_TO_SIGN, //
		SIGN_NO_SUCH_PADDING, //
		SIGN_INVALID_KEY, //
		SIGN_ILLEGAL_BLOCK_SIZE, //
		SIGN_BAD_PADDING, //
		SIGN_NO_PKCS1_PADDING_ALGORITHM, //
		CERTIFICATE_INVALID_ENCODING, //
		CERTIFICATE_IO_ERROR, //
		TIMESTAMP_IO_ERROR, //
		TIMESTAMP_ERROR, //
		DER_SEQUENCE_IO_ERROR, //
		DOCUMENT_INPUT_FILE_NOT_FOUND, //
		DOCUMENT_INVALID_PDF_FILE, //
		DOCUMENT_CANT_CREATE_TEMP_FILE, //
		DOCUMENT_OUTPUT_FILE_NOT_FOUND, //
		DOCUMENT_IO_ERROR, //
		DOCUMENT_PDF_SETUP_ERROR, //
		SIGN_CANT_CREATE_SIGNATURE, //
		SIGN_FONT_NOT_FOUND, //
		SIGN_INVALID_IMAGE_ELEMENT, //
		SIGN_CANT_PRECLOSE_DOCUMENT, //
		SIGN_CANT_GET_CONTENT_BYTES_TO_SIGN, //
		APPEARANCE_ERROR, //

		CERTIFICATE_INVALID, //
		CERTIFICATE_NOT_SUPPORTED, //
		CERTIFICATE_EMPTY_CHAIN, //
		SIGN_INVALID, //

		UNKNOWN, //
		SERVER_ERROR, // Internal server errors
		SERVER_AUTH,

	}

	private static final long serialVersionUID = 1L;

	private final OpenSignatureExceptionReason reason;
	private URL ocspServer = null;

	public OpenSignatureException(String message, OpenSignatureExceptionReason reason) {
		super(message);
		this.reason = reason;
	}

	public OpenSignatureException(Throwable cause, OpenSignatureExceptionReason reason) {
		super(cause);
		this.reason = reason;
	}

	public OpenSignatureException(String message, Throwable cause, OpenSignatureExceptionReason reason) {
		super(message, cause);
		this.reason = reason;
	}

	public OpenSignatureException(String message, Throwable cause, OpenSignatureExceptionReason reason, URL ocspServer) {
		this(message, cause, reason);
		this.ocspServer = ocspServer;
	}

	@Override
	public String toString() {
		String exception = String.format("Reason: %s. %s", this.getReason().toString(), super.toString());
		return exception;
	}

	public OpenSignatureExceptionReason getReason() {
		return reason;
	}

	public URL getOcspServer() {
		return ocspServer;
	}

}
