package tech.espublico.pades.server.di.exceptions;

import java.util.Set;

import tech.espublico.pades.server.di.ServiceEntry;

public class ServiceInstantiationException extends RuntimeException {

	public ServiceInstantiationException(ServiceEntry serviceEntry, Exception e) {
		super(String.format("Cannot instantiate service [%s]", serviceEntry.getName()), e);
	}

	public ServiceInstantiationException(String name, Set<String> chain) {
		super(String.format("Circular dependency for component [%s] chain [%s]", name, String.join("->", chain)));
	}
}
