package tech.espublico.pades.server.di;

import tech.espublico.pades.server.di.exceptions.ServiceInstantiationException;

public class ServiceFactory {

	public <T> T newInstance(ServiceEntry serviceEntry) {
		try {
			return (T) serviceEntry.getServiceClass().newInstance();
		} catch (Exception e) {
			throw new ServiceInstantiationException(serviceEntry, e);
		}
	}

}
